﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports System.IO
Imports Microsoft.VisualBasic.FileIO

Public Class ParseTextFilePanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents DataGridView1 As System.Windows.Forms.DataGridView
    Friend WithEvents BackgroundWorker1 As System.ComponentModel.BackgroundWorker


    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        Me.DataGridView1 = New System.Windows.Forms.DataGridView
        Me.BackgroundWorker1 = New System.ComponentModel.BackgroundWorker
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.AutoSize = False
        Me.DescriptionTextBox.Multiline = True
        Me.DescriptionTextBox.Size = New System.Drawing.Size(568, 51)
        Me.DescriptionTextBox.Text = "The TextFieldParser parses delimited and fixed-width files.  This example automat" & _
            "ically detects the delimiter in the file and populates a DataGridView control wi" & _
            "th the fields from the file.  "
        '
        'ExececuteMethodButton
        '
        '
        'ResetValuesButton
        '
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.DataGridView1)
        Me.GroupBox2.Controls.SetChildIndex(Me.DataGridView1, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.EndParenLabel, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ExececuteMethodButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ResetValuesButton, 0)
        '
        'DataGridView1
        '
        Me.DataGridView1.Location = New System.Drawing.Point(22, 206)
        Me.DataGridView1.Name = "DataGridView1"
        Me.DataGridView1.Size = New System.Drawing.Size(547, 166)
        Me.DataGridView1.TabIndex = 4
        '
        'BackgroundWorker1
        '
        Me.BackgroundWorker1.WorkerReportsProgress = False
        Me.BackgroundWorker1.WorkerSupportsCancellation = False
        '
        'ParseTextFilePanel
        '
        Me.Name = "ParseTextFilePanel"
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Shared panelInstance As ParseTextFilePanel
    Friend WithEvents readFileFileChooser As New FileChooser()
    Friend WithEvents encodingComboBox As New ComboBox()
    Private delimiters As String()
    Private filename As String

    ''' <summary>
    ''' 获取此面板的全局实例
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As ParseTextFilePanel
        If (panelInstance Is Nothing) Then
            panelInstance = New ParseTextFilePanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板并为 My.Computer.FileSystem.OpenTextFieldParser() 的每个参数添加一个控件
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ReadFile_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("filename", readFileFileChooser)
        MyBase.AddParameter("encoding", encodingComboBox)
    End Sub

    ''' <summary>
    ''' 为此面板上的控件添加默认值
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.OpenTextFileReader("
        encodingComboBox.Items.Clear()
        readFileFileChooser.Reset()
        encodingComboBox.Items.AddRange(New String() {"ASCII", "BigEndianUnicode", "Unicode", "UTF7", "UTF8", "UTF32"})
        encodingComboBox.AutoSize = True
        encodingComboBox.SelectedItem = "ASCII"
    End Sub

    ''' <summary>
    ''' 执行分析器并将每个字段作为列放在 DataGridView 中。此操作在后台执行以适应大型文件。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        Try
            filename = Me.readFileFileChooser.Filename
            delimiters = New String() {GuessDelimiter(filename)}

            '针对文件中的每个字段，将一列添加到 DataGridView 中
            AddColumns(filename, delimiters)

            Me.BackgroundWorker1.WorkerReportsProgress = True
            Me.BackgroundWorker1.RunWorkerAsync()

        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    ''' <summary>
    ''' 针对文件中的每个字段，将一列添加到 DataGridView 中
    ''' </summary>
    ''' <param name="filename"></param>
    ''' <param name="delimiters"></param>
    ''' <remarks></remarks>
    Private Sub AddColumns(ByVal filename As String, ByVal delimiters As String())
        Using parser As TextFieldParser = My.Computer.FileSystem.OpenTextFieldParser(filename)
            parser.Delimiters = delimiters
            Dim fields As String()
            ' 计算出 DataGridView 应有多少列：
            fields = parser.ReadFields()

            With Me.DataGridView1
                .RowHeadersVisible = False
                Dim fieldIndex As Integer = 0
                For Each field As String In fields
                    '添加一列并对其进行相应配置
                    .Columns.Add(fieldIndex.ToString, field)
                    .Columns(fieldIndex).MinimumWidth = 1
                    .Columns(fieldIndex).AutoSizeMode = DataGridViewAutoSizeColumnMode.DisplayedCells
                    fieldIndex += 1
                Next
                .ReadOnly = True
                .RowHeadersVisible = False
                .ColumnHeadersVisible = False
            End With
        End Using
    End Sub

    ''' <summary>
    ''' 推测此文件的分隔符。
    ''' </summary>
    ''' <param name="filename"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Private Function GuessDelimiter(ByVal filename As String) As String
        Dim line As String
        Const numPreviewRows As Integer = 50
        Dim currentLineNumber As Integer = 1
        Dim possibleDelimiters() As String = {vbTab, " ", ";", ",", "|"}
        Dim delimiterCount(possibleDelimiters.Length) As Integer

        ' 循环访问该文件并计算每个分隔符在行中出现的次数。
        ' 保留每个分隔符的总出现次数并返回在整个文件中出现次数最多的
        ' 分隔符。
        Using fileReader As StreamReader = My.Computer.FileSystem.OpenTextFileReader(Filename)
            While ((fileReader.Peek() > 0) And (currentLineNumber <= numPreviewRows))
                line = fileReader.ReadLine()
                For index As Integer = 0 To possibleDelimiters.Length - 1
                    delimiterCount(index) += line.Split(possibleDelimiters(index).ToCharArray).Length
                Next
            End While
        End Using

        Dim maxOccurIndex As Integer = 0
        ' 找出哪个分隔符出现得最频繁
        For index As Integer = 0 To delimiterCount.Length - 1
            If (delimiterCount(index) >= delimiterCount(maxOccurIndex)) Then
                maxOccurIndex = index
            End If
        Next
        Return possibleDelimiters(maxOccurIndex)
    End Function

    ''' <summary>
    ''' 将这些控件值重置为它们的默认值
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

    '在后台分析该文件
    Private Sub BackgroundWorker1_DoWork(ByVal sender As Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork
        '现在填充行：
        Using fileParser As TextFieldParser = My.Computer.FileSystem.OpenTextFieldParser(filename)
            fileParser.Delimiters = delimiters
            While (Not fileParser.EndOfData)
                Me.BackgroundWorker1.ReportProgress(0, fileParser.ReadFields())
            End While
        End Using
    End Sub

    Private Sub BackgroundWorker1_ProgressChanged(ByVal sender As Object, ByVal e As System.ComponentModel.ProgressChangedEventArgs) Handles BackgroundWorker1.ProgressChanged
        Me.DataGridView1.Rows.Add(CType(e.UserState, String()))
    End Sub
End Class
